/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.UUID;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class Utils {
    public static final Style GRAY_STYLE = new Style().func_150238_a(TextFormatting.GRAY);

    private Utils() {
    }

    public static TextComponentTranslation getFormattedCoordinates(BlockPos pos) {
        return new TextComponentTranslation("messages.securitycraft:formattedCoordinates", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
    }

    public static TextComponentTranslation localize(Block block, Object ... params) {
        return Utils.localize(block.func_149739_a() + ".name", params);
    }

    public static TextComponentTranslation localize(Item item, Object ... params) {
        return Utils.localize(item.func_77658_a() + ".name", params);
    }

    public static TextComponentTranslation localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] instanceof BlockPos) {
                params[i] = Utils.getFormattedCoordinates((BlockPos)params[i]);
                continue;
            }
            if (!(params[i] instanceof Block)) continue;
            params[i] = new TextComponentTranslation(((Block)params[i]).func_149739_a() + ".name", new Object[0]);
        }
        return new TextComponentTranslation(key, params);
    }

    public static boolean doesEntityOwn(Entity entity, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof IOwnable && ((IOwnable)te).isOwnedBy(entity);
    }

    public static void addScheduledTask(World world, Runnable runnable) {
        if (world.field_72995_K) {
            Minecraft.func_71410_x().func_152344_a(runnable);
        } else {
            ((WorldServer)world).func_152344_a(runnable);
        }
    }

    public static double lerp(double delta, double start, double end) {
        return start + (end - start) * delta;
    }

    public static float lerp(float delta, float start, float end) {
        return start + (end - start) * delta;
    }

    public static Vec3d lerp(Vec3d from, Vec3d to, double delta) {
        return new Vec3d(Utils.lerp(delta, from.field_72450_a, to.field_72450_a), Utils.lerp(delta, from.field_72448_b, to.field_72448_b), Utils.lerp(delta, from.field_72449_c, to.field_72449_c));
    }

    public static Vec3d atCenterOf(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static String getLanguageKeyDenotation(Object obj) {
        if (obj instanceof TileEntity) {
            TileEntity te = (TileEntity)obj;
            return Utils.getLanguageKeyDenotation(te.func_145838_q());
        }
        if (obj instanceof Block) {
            return ((Block)obj).func_149739_a().substring(5);
        }
        if (obj instanceof Entity) {
            ResourceLocation name = EntityList.func_191301_a((Entity)((Entity)obj));
            return name == null ? "" : name.toString();
        }
        if (obj instanceof IBlockState) {
            return Utils.getLanguageKeyDenotation(((IBlockState)obj).func_177230_c());
        }
        return "";
    }

    public static void setUUID(NBTTagCompound tag, String key, UUID uuid) {
        tag.func_74783_a(key, Utils.uuidToIntArray(uuid));
    }

    public static UUID getUUID(NBTTagCompound tag, String key) {
        int[] array = tag.func_74759_k(key);
        if (array.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + array.length + ".");
        }
        return Utils.uuidFromIntArray(array);
    }

    public static boolean isInViewDistance(int centerX, int centerZ, int viewDistance, int x, int z) {
        int squareViewDistance;
        int zDistance;
        int xDistance = Math.max(0, Math.abs(x - centerX) - 1);
        int squareDistance = xDistance * xDistance + (zDistance = Math.max(0, Math.abs(z - centerZ) - 1)) * zDistance;
        return squareDistance < (squareViewDistance = viewDistance * viewDistance);
    }

    private static UUID uuidFromIntArray(int[] array) {
        return new UUID((long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL, (long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL);
    }

    private static int[] uuidToIntArray(UUID uuid) {
        return Utils.leastMostToIntArray(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    private static int[] leastMostToIntArray(long mostSignificantBits, long leastSignificantBits) {
        return new int[]{(int)(mostSignificantBits >> 32), (int)mostSignificantBits, (int)(leastSignificantBits >> 32), (int)leastSignificantBits};
    }

    public static void updateBlockEntityWithItemTag(TileEntity be, ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("BlockEntityTag");
        if (tag != null) {
            NBTTagCompound beData = be.func_189515_b(new NBTTagCompound());
            NBTTagCompound dataCopy = beData.func_74737_b();
            beData.func_179237_a(tag);
            if (!beData.equals((Object)dataCopy)) {
                be.func_145839_a(beData);
            }
        }
        if (be.field_145847_g == 0) {
            be.field_145847_g = stack.func_77960_j();
        }
    }
}

